/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/***********************************************************************************************
 * Only this header-file has to be included in your application to use the RAYLASE TraceBuffer API.
 * Everything is included from this file.
 ***********************************************************************************************/
#ifndef TRACEBUFFER_API_
#define TRACEBUFFER_API_

/* Global defines and types used in the SPICE3 API */
#include "rltbTypes.h"

/* All headers containing the API function calls are included here */
// #include "TraceBufferAPI.h"

RLTB_C_API rltbHandle rltbConnect(const char* hostNameOrAddress);
RLTB_C_API rltbResult rltbDisconnect(rltbHandle handle);
RLTB_C_API rltbResult rltbIsConnected(rltbHandle handle, bool* outIsConnected);

RLTB_C_API rltbResult rltbGetReadTimeout(rltbHandle handle, int32_t* outTimeout);
RLTB_C_API rltbResult rltbSetReadTimeout(rltbHandle handle, int32_t timeoutMs);

RLTB_C_API rltbResult rltbInitConfig(rltbTraceBufferConfig* outConfig);
RLTB_C_API rltbResult rltbGetConfig(rltbHandle handle, rltbTraceBufferConfig* outConfig);
RLTB_C_API rltbResult rltbSetConfig(rltbHandle handle, const rltbTraceBufferConfig* config);

RLTB_C_API rltbResult rltbClear(rltbHandle handle);
RLTB_C_API rltbResult rltbStart(rltbHandle handle);
RLTB_C_API rltbResult rltbStop(rltbHandle handle);

RLTB_C_API rltbResult rltbTryRead(rltbHandle handle, rltbTraceEvent* buffer, size_t index, size_t maxCount, size_t* count);
RLTB_C_API rltbResult rltbRead(rltbHandle handle, rltbTraceEvent* buffer, size_t index, size_t maxCount, size_t* count);

RLTB_C_API rltbResult rltbAcquire(rltbHandle handle, uint16_t startLabel, uint16_t endLabel, size_t* count);
RLTB_C_API rltbResult rltbGetAcquiredElements(rltbHandle handle, rltbTraceEvent* buffer, size_t index, size_t maxCount, size_t* count);

RLTB_C_API rltbResult rltbToSignedPosition(rltbTraceEvent* traceEvents, size_t count);
RLTB_C_API int32_t rltbToSignedPositionVal(int64_t value);

static const double rltbTickPerMicroSecond = 64.0;
static const double rltbMicroSecondPerTick = 1.0 / 64.0;

#endif // TRACEBUFFER_API_
